#pragma once

#include "darklite/darklite_globals.h"

void RenderPig(float time)
{
	HIVCullModeZ(D3DCULL_CCW, true);
	HIVAlpha(false);
	D3DXMATRIX m;
	Effects.SetRef("pig");
	char *buff[] = {"g1", "g2", "g3", "g4", "g5", "g6"}; 
	D3DXCOLOR b[6];
	b[0] = D3DXCOLOR(1.f, 0.f, 0.f, 0.f);
	b[1] = D3DXCOLOR(0xb29180);
	b[2] = D3DXCOLOR(0xb29180);
	b[3] = D3DXCOLOR(0.f, 0.f, 0.f, 0.f);
	b[4] = D3DXCOLOR(0x7f774e);
	b[5] = D3DXCOLOR(0x7f774e);

	Effects.BeginEffect(1);
		m = Meshes.Get(buff[0])->GetMatrix(0.f);
		Effects.Get()->SetMatrix("matWorldViewProjection", &(m*camera.GetViewProjectionMatrix()));
		Effects.Get()->SetMatrix("matWorldView", &(m*camera.GetViewMatrix()));
		Effects.Get()->SetMatrix("matWorld", &m);
		Effects.Get()->SetFloatArray("CameraPosition", camera.Position, 3);
		Effects.Get()->SetFloatArray("DiffuseColor", b[0], 4);
		Effects.Get()->SetTexture("tex0", Textures.Get("eyes"));
		Effects.Get()->CommitChanges();
		Meshes.Get(buff[0])->RenderMesh();
	Effects.EndEffect();

	Effects.BeginEffect(0);
	for(int i=1;i<6;i++)
	{
		m = Meshes.Get(buff[i])->GetMatrix(0.f);
		Effects.Get()->SetMatrix("matWorldViewProjection", &(m*camera.GetViewProjectionMatrix()));
		Effects.Get()->SetMatrix("matWorldView", &(m*camera.GetViewMatrix()));
		Effects.Get()->SetMatrix("matWorld", &m);
		Effects.Get()->SetFloatArray("CameraPosition", camera.Position, 3);
		Effects.Get()->SetFloatArray("DiffuseColor", b[i], 4);
		Effects.Get()->CommitChanges();
		Meshes.Get(buff[i])->RenderMesh();
	}
	Effects.EndEffect();

};


void RenderPigColor(D3DXMATRIX matrix)
{
	D3DXMATRIX m;
	Effects.SetRef("pig");
	char *buff[] = {"g1", "g2", "g3", "g4", "g5", "g6"}; 
	D3DXCOLOR b[6];
	b[0] = D3DXCOLOR(1.f, 0.f, 0.f, 0.f);
	b[1] = D3DXCOLOR(0xb29180);
	b[2] = D3DXCOLOR(0xb29180);
	b[3] = D3DXCOLOR(0.f, 0.f, 0.f, 0.f);
	b[4] = D3DXCOLOR(0x7f774e);
	b[5] = D3DXCOLOR(0x7f774e);

	Effects.BeginEffect(1);
		m = Meshes.Get(buff[0])->GetMatrix(0.f)*matrix;
		Effects.Get()->SetMatrix("matWorldViewProjection", &(m*camera.GetViewProjectionMatrix()));
		Effects.Get()->SetMatrix("matWorldView", &(m*camera.GetViewMatrix()));
		Effects.Get()->SetMatrix("matWorld", &m);
		Effects.Get()->SetFloatArray("CameraPosition", camera.Position, 3);
		Effects.Get()->SetFloatArray("DiffuseColor", b[0], 4);
		Effects.Get()->SetTexture("tex0", Textures.Get("eyes"));
		Effects.Get()->CommitChanges();
		Meshes.Get(buff[0])->RenderMesh();
	Effects.EndEffect();

	Effects.BeginEffect(0);
	for(int i=1;i<6;i++)
	{
		m = Meshes.Get(buff[i])->GetMatrix(0.f)*matrix;
		Effects.Get()->SetMatrix("matWorldViewProjection", &(m*camera.GetViewProjectionMatrix()));
		Effects.Get()->SetMatrix("matWorldView", &(m*camera.GetViewMatrix()));
		Effects.Get()->SetMatrix("matWorld", &m);
		Effects.Get()->SetFloatArray("CameraPosition", camera.Position, 3);
		Effects.Get()->SetFloatArray("DiffuseColor", b[i], 4);
		Effects.Get()->CommitChanges();
		Meshes.Get(buff[i])->RenderMesh();
	}
	Effects.EndEffect();

};

void RenderPig(D3DMATRIX mat)
{
	char *buff[] = {"g1", "g2", "g3", "g4", "g5", "g6"}; 

	for(int i=0;i<6;i++)
	{
		D3DXMATRIX m = Meshes.Get(buff[i])->GetMatrix(0.f)*mat;
		Effects.Get()->SetMatrix("matWorldViewProjection", &(m*camera.GetViewProjectionMatrix()));
		Effects.Get()->SetMatrix("matWorldView", &(m*camera.GetViewMatrix()));
		Effects.Get()->SetMatrix("matWorld", &m);
		Effects.Get()->CommitChanges();
		Meshes.Get(buff[i])->RenderMesh();
	}
};